/**
 * Creator for Overlay UI 
 * Object responsible for 
 * 	- showing loaders, dialogs, errors and other info-boxes placed wrapped in overlay, 
 *  - showing add/edit form for feeds (optionally depending on Application settings) 
 * It builds proper html templates for: 
 *  - overlay content as dialog, errors and other informations
 * 	- feed form
 */
Application.UI.overlay = (function(){
	
	var loader   = null;
	/**
	 * 
	 * */
	function hideOverlay(){
		var overlay = document.getElementById( 'overlay' );
		overlay.clear();
		overlay.addClass( 'hidden' );
	}
	
	/**
	 * display overlay with box
	 * */
	function showOverlay(box){
		var overlay = document.getElementById( 'overlay' );
		overlay.clear(); // just in case if error,dialog remained
		if( box )overlay.appendChild( box );
		overlay.removeClass( 'hidden' );
	}
	
	/**
	 * create information-box
	 * */
	function createInfoDialog(params) {
		
		var dialog 	 	 = document.createElement( 'div' ),
			message  	 = document.createElement( 'p' ),
			buttonOk 	 = document.createElement( 'span' ),
			title 	 	 = document.createElement( 'h3' );
	
		title.appendChild( document.createTextNode( params.title ) );
		message.appendChild( document.createTextNode( params.message ) );
		
		dialog.appendChild( title );
		dialog.appendChild( message );
		
		buttonOk.appendChild( document.createTextNode( 'OK' ) );
		buttonOk.addEventListener( 'click', function(){
			hideOverlay();
		}, false );
		buttonOk.addClass( 'button' );
		buttonOk.addClass( 'button' );
		buttonOk.id = "btnOk";
		buttonOk.setNav('#btnOk','#btnOk','#btnOk','#btnOk');
		
		dialog.appendChild( buttonOk );
		dialog.id = 'confirmDialog';
		dialog.addClass( 'overlayBox' );
		dialog.addClass( 'box' );
		return dialog;
	}
	
	/**
	 * creates dialog-box with confirm button and binds proper callbacks
	 * @return {object} html
	 * */
	function createConfirmDialog(params) {
		
		var dialog 	 	 = document.createElement( 'div' ),
			message  	 = document.createElement( 'p' ),
			buttonOk 	 = document.createElement( 'button' ),
			buttonCancel = document.createElement( 'button' ),
			title 	 	 = document.createElement( 'h3' );
	
		title.appendChild( document.createTextNode( params.title ) );
		message.appendChild( document.createTextNode( params.message ) );
		
		dialog.appendChild( title );
		dialog.appendChild( message );
		
		buttonCancel.appendChild( document.createTextNode( 'Cancel' ) );
		buttonCancel.addEventListener( 'click', params.onCancel, false );
		buttonCancel.addClass( 'button' );
		buttonCancel.id = "btnCancel";
		buttonCancel.focus();
		buttonCancel.setNav('#btnCancel','#btnCancel','#btnCancel','#btnOk');
		
		
		buttonOk.appendChild( document.createTextNode( 'OK' ) );
		buttonOk.addEventListener( 'click', function(){
			params.onOk();
			hideOverlay();
		}, false );
		buttonOk.addClass( 'button' );
		buttonOk.id = "btnOk";
		buttonOk.setNav('#btnOk','#btnCancel','#btnOk','#btnOk');
		
		dialog.appendChild( buttonOk );
		dialog.appendChild( buttonCancel );
		dialog.id = 'confirmDialog';
		dialog.addClass( 'overlayBox' );
		dialog.addClass( 'box' );
		return dialog;
	}

	/**
	 * create loader
	 * @return {object} html
	 * */
	function createLoader(params){
		
		var loader 	 	 = document.createElement( 'div' ),
			message  	 = document.createElement( 'p' ),
			title 	 	 = document.createElement( 'h3' );
		
		title.appendChild( document.createTextNode( params.title ? params.title : 'Loading' ) );
		message.appendChild( document.createTextNode( params.message ? params.message : 'content is loading...' ) );
	
		loader.appendChild( title );
		loader.appendChild( message );
	
		loader.id = 'loader';
		loader.addClass( 'overlayBox' );
		loader.addClass( 'box' );
		return loader;
		
	}
	
	/**
	 * create error-box and dislays information about error
	 * @return {object} html 
	 * */
	function createErrorMsg(params){
		
		var error 	 	 = document.createElement( 'div' ),
			buttonClose  = document.createElement( 'button' ),
			message  	 = document.createElement( 'p' ),
			title 	 	 = document.createElement( 'h3' );

		title.appendChild( document.createTextNode( params.title ? params.title : 'Error' ) );
		message.appendChild( document.createTextNode( params.message ? params.message : 'Error appears...' ) );
	
		buttonClose.appendChild( document.createTextNode( 'Close' ) );
		buttonClose.addEventListener( 'click', hideOverlay, false );
		buttonClose.addClass( 'button' );
		buttonClose.id = 'btnClose' ;
		buttonClose.setNav('#btnClose','#btnClose','#btnClose','#btnClose');
		error.appendChild( title );
		error.appendChild( message );
		error.appendChild( buttonClose );
		
		error.id = 'error';
		error.addClass( 'errorBox' );
		error.addClass( 'box' );
		
		return error;
		
	}
	return {
		showConfirmDialog: function( params){
			var dialog = createConfirmDialog( params );
			showOverlay(dialog);
			dialog.getElementsByTagName('button')[0].focus();
		},
		showInfoDialog: function( params){
			var dialog = createInfoDialog( params );
			showOverlay(dialog);
			dialog.getElementsByTagName('button')[0].focus();
		},
		showLoader: function(params){
			var loader = createLoader(params);
			showOverlay(loader);
		},
		showErrorMsg: function(params){
			var error = createErrorMsg(params);
			showOverlay(error);
			error.getElementsByTagName('button')[0].focus();
		},
		removeConfirmDialog: function(){
			hideOverlay();
		},
		hideLoader: function(){
			hideOverlay();
		},
		loaderMsg: function(msg){
			if(x=document.getElementById('loader')){
				var p = x.getElementsByTagName('p')[0].textContent = msg;
			}
		}
	}
})();
